<?php

namespace RtRasel\LaravelInstaller\Controllers;
use Validator;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use RtRasel\LaravelInstaller\Constants\Installer;
use RtRasel\LaravelInstaller\Helpers\LicenseManager;

class LicenseController extends Controller
{
    /**
     * @var LicenseManager
     */
    protected $LicenseManager;

    /**
     * @param  LicenseManager  $licenseManager
     */
    public function __construct(LicenseManager $licenseManager)
    {
        $this->LicenseManager = $licenseManager;
    }

    /**
     * Display the installer license page.
     *
     * @return \Illuminate\Http\Response
     */
    public function license()
    {
        if(!session('permissions')){
            return redirect()->back();
        }
        
        return view('laravelinstaller::license');
    }

    /**
     * Verify License
     *
     * @param  Request  $request
     * @param  Redirector  $redirect
     */
    public function verify(Request $request)
    {
        $rules = Installer::CONFIG['license']['form']['rules'];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->route('LaravelInstaller::license')->withInput()->withErrors($validator->errors());
        }

        $result = $this->verifyLicense($request);
        if (!$result) {
            return redirect()->route('LaravelInstaller::license')->withInput()->withErrors([
                'license_verification' => __('License Verification Failed'),
            ]);
        }

        if (!$result['status']) {
            return redirect()->route('LaravelInstaller::license')->withInput()->withErrors([
                'license_verification' => __($result['message']),
            ]);
        }
        
        session()->put('license', true);

        return redirect()->route('LaravelInstaller::license')
                        ->with(['success' => __($result['message'])]);
    }

    private function verifyLicense(Request $request){
        return $this->LicenseManager->activate_license($request->license_code);
    }

}
